TakipiMiniSignupElement = function(dialogHolderEl, loginPage, redirectUrl, errorRedirect, headerText, btnText, appUrl)
{
	this.dialogHolderEl = dialogHolderEl;
	this.loginPage = loginPage;
	
	this.dialogHolderEl.append(this.buildForm(headerText, btnText));	
	
	this.emailInputEl = $(".emailInput", this.dialogHolderEl);
	this.errorLabelEl = $(".errorLabel", this.dialogHolderEl);
	this.createBtnEl = $(".createStubAccountBtn", this.dialogHolderEl);

	this.servletUrl = "/app/account/stub/validate";
	this.appUrl = (appUrl ? appUrl : "");
	this.redirectUrl = redirectUrl;
	this.errorRedirect = errorRedirect;
	this.stubPlaceholder = "THATS_WHY_ONE_SHOULD_NEVER_USE_REQUIRED_IN_A_PROTO";
	
	var miniSignupElement = this;
	
	this.createBtnEl.click(function() {
		miniSignupElement.createStubAccount();
		return false;
	});

	this.emailInputEl.keydown(function(event) {
		var keyCode = (event.keyCode ? event.keyCode : event.which);
		
		if (keyCode == 13)
		{
			miniSignupElement.createStubAccount();
			return false;
		}
		
		return true;
	});
	
	this.hideErrorLabel();
}
TakipiMiniSignupElement.prototype = {
	buildForm:function(headerText, btnText)
	{
		var headerTextValue = (headerText ? headerText : "Solve monster bugs");
		var btnTextValue = (btnText ? btnText : "Start using Takipi");
		
		return '<div class="stubSignupElement"> \
					<form class="stubSignupForm"> \
						<div class="header">' + headerTextValue + '</div> \
						<input class="emailInput" type="text" autocomplete="off" placeholder="Enter your mail"></input> \
						<div class="createStubAccountBtn">' + btnTextValue + '</div> \
					</form> \
					<div class="errorLabel"></div> \
					<div class="footer"> \
						<div>Java / Scala developers</div> \
						<div>free trial</div> \
					</div> \
				</div>';
	},
	createStubAccount:function()
	{
		this.hideErrorLabel();
		
		if (!this.validateEmail())
		{
			this.showInvalidEmailError();
			return;
		}
		
		var request = {
			"email":this.emailInputEl.val()
		}
		
		this.disableForm();
		
		var miniSignupElement = this;
		
		$.ajax({
			type: "POST",
			url:  this.appUrl + miniSignupElement.servletUrl,
			data: JSON.stringify(request)})
		.success(function(data)
		{
			if (data.is_valid)
			{
				window.location.href = 
					miniSignupElement.redirectUrl +
					"?cs" +															// cs - createStub
					"&e=" + miniSignupElement.encodeURLSafeBase64(request.email) +	// e - email
					"&er=" + encodeURIComponent(miniSignupElement.errorRedirect);	// er - error redirect
			}
			else
			{
				miniSignupElement.showEmailExistError();
				miniSignupElement.enableForm();
			}
		})
		.error(function(data)
		{
			miniSignupElement.showServerError();
			miniSignupElement.enableForm();
		});
	},
	disableForm:function()
	{
		this.emailInputEl.prop("disabled", true);
		this.createBtnEl.addClass("waitForResponse");
	},
	enableForm:function()
	{
		this.emailInputEl.prop("disabled", false);
		this.createBtnEl.removeClass("waitForResponse");
	},
	validateEmail:function()
	{
		var email = this.emailInputEl.val();
		
		return ((email != "") &&
				(this.isValidEmail(email)));
	},
	hideErrorLabel:function()
	{
		this.errorLabelEl.html('').hide();
	},
	showServerError:function()
	{
		this.errorLabelEl.html('Problem with server').show();
	},
	showInvalidEmailError:function()
	{
		this.errorLabelEl.html('Invalid email').show();
	},
	showEmailExistError:function()
	{
		this.errorLabelEl.html('User already exists <a class="loginLink" href="' + this.loginPage + '">Log in</a>').show();
	},
	encodeURLSafeBase64:function(str) // ZZZ: copied from takipiUtilityMethods
	{
		return $.base64.encode(str).replace(/\//g, '.').replace(/\+/g, '_').replace(/\=/g, '-');
	},
	isValidEmail:function(email) // ZZZ: copied from takipiUtilityMethods
	{
		var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
		
		return re.test(email);
	}
};
