var monthsArr = ['january', 'february', 'march', 'april', 'may', 'june',
						 'july', 'august', 'september', 'october', 'november', 'december'];

var btnMonthsArr = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
				 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

function checkRedirect()
{
	var startMonth = (new Date).getMonth();
	
	var path = window.location.pathname;

	var monthPath = path.substring(1);

    if (monthPath == "/" || monthPath == "")
    {
    	window.location.href = monthsArr[startMonth];
    	return true;
    }

    return false;
}

function initFunction()
{
	var startMonth = (new Date).getMonth();
	
	var path = window.location.pathname;

	var monthPath = path.substring(1);

    if (monthPath == "/" || monthPath == "")
    {
    	window.location.href = monthsArr[startMonth];
    	return;
    }

	var shouldRemoveTooltip = false;
	var createdThrobber = false;

	var tooltip = $('<div/>').qtip({
		id: 'fullcalendar',
		prerender: true,
		content: {
			text: ' ',
			title: {
				text: ' ',
				button: true
			}
		},
		position: {
			my: 'bottom center',
			at: 'top center',
			target: 'mouse',
			viewport: $('#fullcalendar'),
			adjust: {
				mouse: false,
				scroll: false,
				y: 1,
				x: 2
			}
		},
		show: false,
		hide: false,
		style: 'qtip-blue'
	}).qtip('api');
	
	if (monthPath != "/" && monthPath != "")
	{
		startMonth = getMonthId(monthPath);
		_gas.push(['_trackPageview', window.location.pathname + window.location.search + window.location.hash]);
	}

	var selectedBtnStr = "#btn" + btnMonthsArr[startMonth];
	$(selectedBtnStr).addClass('monthSelected');

    $('#calendar').fullCalendar({
    	height: 600,
        weekends: true,
        lazyFetching: true,
        titleFormat:
        {
    		month: 'MMMM // yyyy'
    	},
        header:
    	{
    		left:   '',
		    center: 'title',
		    right:  ''
    	},
        dayClick: function() { tooltip.hide() },
		eventResizeStart: function() { tooltip.hide() },
		eventDragStart: function() { tooltip.hide() },
		viewDisplay: function() { tooltip.hide() },
		loading: function(isLoading, view) {
			if (isLoading) {
				if (!createdThrobber) {
					$(document.createElement('div')).css('display', 'inline-block').html("<img id=\"throbber\" src=\"img/loading.gif\" style=\"padding-left: 5px; padding-top: 3px;\"/>")
						.appendTo($('.fc-header-center'));
				}
				$('#throbber').show();
				createdThrobber = true;
			} else {
				$('#throbber').hide();
			}
		},
		eventMouseover: function(event, jsEvent, view) {
			//
			// lll: The tooltip isn't really working. it only display horizental line at the bottom of the page.
			//

			// var descObj = $.parseJSON(event.description);

	  		// var content = 
			// 	'<div style="tooltip-content"><div style="padding-top:6px;"><span style="font-weight: bold;">Price: </span>' + descObj.price + '</div>' + 
			// 	'<div style="padding-top:10px;"><a href="'+descObj.link+'" target="_blank" style="font-weight: bold;">Visit website</a></div></div>';

			// tooltip.set({
			// 	'content.text': content,
			// 	'content.title': event.location
			// })
			// .reposition(jsEvent).show(jsEvent);
			// shouldRemoveTooltip = false;
		},
        eventSources: 
        	[
        		{ // Free
        			url: 'https://www.google.com/calendar/feeds/qra8vl2kio5rbbv14jsikea6og%40group.calendar.google.com/public/basic',
        		 	color: '#8dc63f',
        		 	textColor: 'white'
        		},
        		{ // Mega
        			url: 'https://www.google.com/calendar/feeds/ca9p5u0m23l0igmcn1lgf6o3p4%40group.calendar.google.com/public/basic',
        		 	color: '#f06eaa',
        		 	textColor: 'white'
        		},
        		{ // NA
        			url: 'https://www.google.com/calendar/feeds/ud89prutueikqor75ta7bpjoqo%40group.calendar.google.com/public/basic',
        		 	color: '#8dc63f',
        		 	textColor: 'white'
        		},
				{ // Price
        			url: 'https://www.google.com/calendar/feeds/iu744clfdp20fr0011o25spqcg%40group.calendar.google.com/public/basic',
        		 	color: '#18b2c3',
        		 	textColor: 'white'
        		}
        	],
        month: startMonth
    })

    $('#btnPrev').click(function() {
    	prevMonth();
    });

    $('#btnNext').click(function() {
    	nextMonth();
    });

    $("#data tr:even").not(':first').hover(
	  function () {
		$(this).css("background","#C9C9C9");
		$(this).css("font-weight","bold");
		$(this).css("color","#ff3a3a");
	  }, 
	  function () {
		$(this).css("background","#EBEBEB");
		$(this).css("font-weight","normal");
		$(this).css("color","black");
	  }
	);
	
	$("#data tr:odd").hover(
	  function () {
		$(this).css("background","#C9C9C9");
		$(this).css("font-weight","bold");
		$(this).css("color","#ff3a3a");
	  }, 
	  function () {
		$(this).css("background","");
		$(this).css("font-weight","normal");
		$(this).css("color","black");
	  }
	);

	var miniLoginDialogEl = $(".miniSignupDialog")
	
	// new TakipiMiniSignupElement(miniLoginDialogEl, "https://app.takipi.com/login.html", "https://app.takipi.com", 
	// 	"http://www.javais.cool/again", "Your email", "Sign up", "https://app.takipi.com");
	new TakipiMiniSignupElement(miniLoginDialogEl, "https://app.takipi.com/login.html", "https://staging1.takipi.net", 
		"http://www.javais.cool/again", "Your email", "Sign up", "https://staging1.takipi.net");
}

function getMonthId(monthStr)
{
	if (monthStr == 'january' || monthStr == 'jan')
	{
		return 0;
	}
	else if (monthStr == 'february' || monthStr == 'feb')
	{
		return 1;
	}
	else if (monthStr == 'march' || monthStr == 'mar')
	{
		return 2;
	}
	else if (monthStr == 'april' || monthStr == 'apr')
	{
		return 3;
	}
	else if (monthStr == 'may')
	{
		return 4;
	}
	else if (monthStr == 'june' || monthStr == 'jun')
	{
		return 5;
	}
	else if (monthStr == 'july' || monthStr == 'jul')
	{
		return 6;
	}
	else if (monthStr == 'august' || monthStr == 'aug')
	{
		return 7;
	}
	else if (monthStr == 'september' || monthStr == 'sep')
	{
		return 8;
	}
	else if (monthStr == 'october' || monthStr == 'oct')
	{
		return 9;
	}
	else if (monthStr == 'november' || monthStr == 'nov')
	{
		return 10;
	}
	else if (monthStr == 'december' || monthStr == 'dec')
	{
		return 11;
	}
}

function nextMonth()
{
	var curMonth = $('#calendar').fullCalendar('getDate').getMonth();
	
	if (monthsArr[curMonth+1] != undefined)
	{
		window.location.href = monthsArr[curMonth+1];
	}
}

function prevMonth()
{
	var curMonth = $('#calendar').fullCalendar('getDate').getMonth();
	
	if (monthsArr[curMonth-1] != undefined)
	{
		window.location.href = monthsArr[curMonth-1];
	}
}
